/************************************************************************************
* Includes the UART Utils.
*
* (c) Copyright 2007, Freescale, Inc. All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
************************************************************************************/
#include "EmbeddedTypes.h"
#include "UartUtil.h"
#include "Uart.h"

#ifndef mSCIxS1_TDRE_c
#define mSCIxS1_TDRE_c      0x80        /* Transmit Data Register Empty Flag. */
#endif

/******************************************************************************/
/******************************************************************************/

/************************************************************************************
*************************************************************************************
* Private macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
 
/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

#if gUart0_Enabled_d || gUart1_Enabled_d

//void UartUtil_TxCallback(unsigned char const *pBuf)
void UartUtil_TxCallback(unsigned char *pBuf)
{
    (void) pBuf;
}

/************************************************************************************/

/************************************************************************************/

void UartUtil_Tx(uint8_t * pData, uint8_t length)
{
  /* wait until module can insert message into uart buffers */
  //while(!UartX_Transmit((unsigned char const*)pData,(index_t)length,UartUtil_TxCallback));
  while(!UartX_Transmit((unsigned char *)pData,(index_t)length,UartUtil_TxCallback));
  /* wait until tx complete */
  while (UartX_IsTxActive());      
}


/************************************************************************************/


void UartUtil_Print(uint8_t* pString, uartUtilBlock_t allowToBlock)
{
  uint16_t i = 0;
  uint8_t*  pTmpString = pString ;
  
  while (*pTmpString != '\0') 
  {
    pTmpString++;
    i++;
  } 
  if(allowToBlock)
  {
    /* wait until module can insert message into uart buffers */
    //while(!UartX_Transmit((unsigned char const*)pString,(index_t)i,UartUtil_TxCallback));
	while(!UartX_Transmit((unsigned char *)pString,(index_t)i,UartUtil_TxCallback));
    /* wait until tx complete */
    while (UartX_IsTxActive());  
  }
  else
  {
    //(void)UartX_Transmit((unsigned char const*)pString,(index_t)i,UartUtil_TxCallback);
	(void)UartX_Transmit((unsigned char *)pString,(index_t)i,UartUtil_TxCallback);
  }
}


/************************************************************************************/

/* Trasform from hex to ascii */

static uint8_t HexToAscii(uint8_t hex)
{
  hex &= 0x0F;
  return hex + ((hex <= 9) ? '0' : ('A'-10));
}

  
/************************************************************************************/


void UartUtil_PrintHex(uint8_t *hex, uint8_t len, uint8_t flags)
{
  uint8_t i=0; 
  uint8_t hexString[5]; /* 2 bytes  - hexadecimal display 
                           1 byte   - separator ( comma, space)
                           2 bytes  - new line (\n\r)  */
  
  if(! (flags & gPrtHexBigEndian_c))
   {
    hex = hex + (len-1);
   }
   
  while(len)
  {
    /* wait until previous hex print transmission is over */  
    while (UartX_IsTxActive());  
      
    /* start preparing the print of a new byte */
    i=0;
    hexString[i++] = HexToAscii((*hex)>>4);
    hexString[i++] = HexToAscii( *hex);

    if(flags & gPrtHexCommas_c)
     {
      hexString[i++] = ',';
     }
    if(flags & gPrtHexSpaces_c) 
     { 
      hexString[i++] = ' ';
     }
    hex = hex + (flags & gPrtHexBigEndian_c ? 1 : -1);
    len--;
    
    if((len == 0) && (flags & gPrtHexNewLine_c))
     {
      hexString[i++] = '\n';
      hexString[i++] = '\r';
     }
     /* transmit formatted byte */      
    //(void)UartX_Transmit((unsigned char const*)hexString,(index_t)i,UartUtil_TxCallback);   
	(void)UartX_Transmit((unsigned char *)hexString,(index_t)i,UartUtil_TxCallback);   
  }
  /* wait to complete the last transmission */
  while (UartX_IsTxActive());
}


/************************************************************************************/


void UartUtil_PrintDec(int32_t integer)
{
  uint8_t temp, i = 19;
  uint8_t DataBuffer[20];
  bool_t  bSign = 0;

  if(integer < 0)
  {
    bSign = 1;
    integer = 0 - integer;
  }
  if(integer == 0)
  {
    DataBuffer[i--] = '0';
  }
  else
  {
    while(integer != 0)
    {
      temp = (uint8_t)(integer % 10);
      integer = (integer - temp)/10;
      DataBuffer[i--] = temp + '0';
    }
  }
  if(bSign)
  {
    DataBuffer[i--] = '-';
  }

  /* wait until previous hex print transmission is over */
    while (UartX_IsTxActive());
  /* transmit formatted byte */
  //(void)UartX_Transmit((unsigned char const*)(DataBuffer + i + 1),(index_t)19 - i,UartUtil_TxCallback);
  (void)UartX_Transmit((unsigned char *)(DataBuffer + i + 1),(index_t)19 - i,UartUtil_TxCallback);
  /* wait to complete the last transmission */
  while (UartX_IsTxActive());
}


#endif  /* gUart0_Enabled_d || gUart1_Enabled_d */